; p30F1010.inc  Standard Include/Header File, Version 1.5
; (c) Copyright 2005-2006 Microchip Technology, All rights reserved

.NOLIST

;******************************************************************************
;
; Important:
; ==========
; The processor must be selected before this file is included. The processor
; may  be selected in the following ways:
;
;       1. Command line switch:
;               C:\> AS -p30F1010
;       2. Placing a ".equ" directive before the ".include":
;               .equ __30F1010, 1
;               .include "p30F1010.inc"
;       3. Setting the processor in the MPLAB Project Dialog
;
; Notes:
; =========================
; 1. This include file defines useful bits of information for the
;    PIC30Fxxxx Family of Digital Signal Controllers (dsPIC).
; 2. The register and bit names used in this file are taken to match the
;    PIC30Fxxxx data sheets as closely as possible.
; 3. This file does not map special function register (SFR) names used in the
;    datasheet to memory locations in the PIC30Fxxxx device. The address
;    mapping for SFR names is done in the device linker script only.
; 4. It does however, provide names for the lower(even address) and
;    higher(odd address) bytes of a special function register. For e.g.,
;    the TMR2 register is 16 bits long and its memory address is provided in
;    the device linker script. This SFR can be alternately accessed as two
;    separate bytes, TMR2L and TMR2H.In such a case, TMR2L maps to the lower
;    byte and TMR2H maps to the higher byte. This mapping is performed in this
;    include file.
; 5. This file maps bit names used in the datasheet to bit offsets/positions
;    in a word [0x000F(15) for the MS bit down to 0x0000(0) for the LS bit].
; 6. SFR bit definitions are listed in the ascending order of SFR memory
;    addresses and are grouped based on the module they belong to. For e.g.,the
;    Core SFR  bits are grouped separately from the Interrupt Controller SFR
;    bits or the  General Purpose Timer SFR bits.
;
; File Structure/Organization:
; ============================
; The sections in this file are organized as shown below:
;       1. Core section
;          a. Byte High and Byte Low definitions for SFRs in the section
;          b. Bit Position Definitions for some SFRS in the section
;       2. Interrupt section
;          a. Byte High and Byte Low definitions for SFRs in the section
;          b. Bit Position Definitions for some SFRS in the section
;       :
;       :
;       13. Peripheral x section
;          a. Byte High and Byte Low definitions for SFRs in the section
;          b. Bit Position Definitions for some SFRS in the section
;       :
;       :
;       N. Useful constants that ease assembly-level programming
;       N+1. Configuration Fuses and Macros
;
; Revision History:
; =================
; ------------------------------------------------------------------------------
; Rev:   Date:        Details:                                   Who:
; ------------------------------------------------------------------------------
; 1.0   6 Jun 2006   New File                                  S Fernandes 
; 1.9  17 Oct 2006   Corrected for SPI registers               S Khare
; ------------------------------------------------------------------------------
;
;******************************************************************************


;==============================================================================
;
; Verify Processor Type
;
;==============================================================================

.IFNDEF __30F1010
   .error "Include file does not match processor setting."
.ENDIF
.NOLIST

;==============================================================================
;
; 1. Core Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 1a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv WREG0L, _WREG0
         .equiv WREG0H, _WREG0+1
         .equiv WREG1L, _WREG1
         .equiv WREG1H, _WREG1+1
         .equiv WREG2L, _WREG2
         .equiv WREG2H, _WREG2+1
         .equiv WREG3L, _WREG3
         .equiv WREG3H, _WREG3+1
         .equiv WREG4L, _WREG4
         .equiv WREG4H, _WREG4+1
         .equiv WREG5L, _WREG5
         .equiv WREG5H, _WREG5+1
         .equiv WREG6L, _WREG6
         .equiv WREG6H, _WREG6+1
         .equiv WREG7L, _WREG7
         .equiv WREG7H, _WREG7+1
         .equiv WREG8L, _WREG8
         .equiv WREG8H, _WREG8+1
         .equiv WREG9L, _WREG9
         .equiv WREG9H, _WREG9+1
         .equiv WREG10L, _WREG10
         .equiv WREG10H, _WREG10+1
         .equiv WREG11L, _WREG11
         .equiv WREG11H, _WREG11+1
         .equiv WREG12L, _WREG12
         .equiv WREG12H, _WREG12+1
         .equiv WREG13L, _WREG13
         .equiv WREG13H, _WREG13+1
         .equiv WREG14L, _WREG14
         .equiv WREG14H, _WREG14+1
         .equiv WREG15L, _WREG15
         .equiv WREG15H, _WREG15+1
         .equiv SPLIML, _SPLIM
         .equiv SPLIMH, _SPLIM+1
         .equiv ACCALL, _ACCAL
         .equiv ACCALH, _ACCAL+1
         .equiv ACCAHL, _ACCAH
         .equiv ACCAHH, _ACCAH+1
         .equiv ACCAUL, _ACCAU
         .equiv ACCBLL, _ACCBL
         .equiv ACCBLH, _ACCBL+1
         .equiv ACCBHL, _ACCBH
         .equiv ACCBHH, _ACCBH+1
         .equiv ACCBUL, _ACCBU
         .equiv PCLL, _PCL
         .equiv PCLH, _PCL+1
         .equiv PCHL, _PCH
         .equiv TBLPAGL, _TBLPAG
         .equiv PSVPAGL, _PSVPAG
         .equiv RCOUNTL, _RCOUNT
         .equiv RCOUNTH, _RCOUNT+1
         .equiv DCOUNTL, _DCOUNT
         .equiv DCOUNTH, _DCOUNT+1
         .equiv DOSTARTLL, _DOSTARTL
         .equiv DOSTARTLH, _DOSTARTL+1
         .equiv DOSTARTHL, _DOSTARTH
         .equiv DOENDLL, _DOENDL
         .equiv DOENDLH, _DOENDL+1
         .equiv DOENDHL, _DOENDH
         .equiv SRL, _SR                        ; See Description in section 1b
         .equiv SRH, _SR+1                      ; See Description in section 1b
         .equiv CORCONL, _CORCON                ; See Description in section 1b
         .equiv CORCONH, _CORCON+1              ; See Description in section 1b
         .equiv MODCONL, _MODCON                ; See Description in section 1b
         .equiv MODCONH, _MODCON+1              ; See Description in section 1b
         .equiv XMODSRTL, _XMODSRT
         .equiv XMODSRTH, _XMODSRT+1
         .equiv XMODENDL, _XMODEND
         .equiv XMODENDH, _XMODEND+1
         .equiv YMODSRTL, _YMODSRT
         .equiv YMODSRTH, _YMODSRT+1
         .equiv YMODENDL, _YMODEND
         .equiv YMODENDH, _YMODEND+1
         .equiv XBREVL, _XBREV                  ; See Description in section 1b
         .equiv XBREVH, _XBREV+1
         .equiv DISICNTL, _DISICNT
         .equiv DISICNTH, _DISICNT+1

;------------------------------------------------------------------------------
; 1b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     SR - Status Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv OA, 0x000F
         .equiv OB, 0x000E
         .equiv SA, 0x000D
         .equiv SB, 0x000C
         .equiv OAB, 0x000B
         .equiv SAB, 0x000A
         .equiv DA, 0x0009
         .equiv DC, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv IPL2, 0x0007
         .equiv IPL1, 0x0006
         .equiv IPL0, 0x0005
         .equiv RA, 0x0004
         .equiv N, 0x0003
         .equiv OV, 0x0002
         .equiv Z, 0x0001
         .equiv C, 0x0000

;------------------------------------------------------------------------------
;     CORCON - Core Configuration Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv US, 0x000C
         .equiv EDT, 0x000B
         .equiv DL2, 0x000A
         .equiv DL1, 0x0009
         .equiv DL0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv SATA, 0x0007
         .equiv SATB, 0x0006
         .equiv SATDW, 0x0005
         .equiv ACCSAT, 0x0004
         .equiv IPL3, 0x0003
         .equiv PSV, 0x0002
         .equiv RND, 0x0001
         .equiv IF, 0x0000

;------------------------------------------------------------------------------
;     MODCON - Modulo Addressing Mode Control Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv XMODEN, 0x000F
         .equiv YMODEN, 0x000E

;------------------------------------------------------------------------------
;     XBREV - Bit Reversed Addressing Mode Control Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv BREN, 0x000F

;==============================================================================
;
; 2.  Input Change Notification Module Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 2a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv CNEN1L, _CNEN1                  ; See description for all
         .equiv CNPU1L, _CNPU1                  ;  registers in sub-section below

;------------------------------------------------------------------------------
; 2b. Bit Position Definitions for some SFRs

;     CNEN1 : Input Change Notification Interrupt Enable Register 1
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv CN7IE, 0x0007
         .equiv CN6IE, 0x0006
         .equiv CN5IE, 0x0005
         .equiv CN4IE, 0x0004
         .equiv CN3IE, 0x0003
         .equiv CN2IE, 0x0002
         .equiv CN1IE, 0x0001
         .equiv CN0IE, 0x0000

;     CNPU1 : Input Change Notification Pullup Enable Register 1
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv CN7PUE, 0x0007
         .equiv CN6PUE, 0x0006
         .equiv CN5PUE, 0x0005
         .equiv CN4PUE, 0x0004
         .equiv CN3PUE, 0x0003
         .equiv CN2PUE, 0x0002
         .equiv CN1PUE, 0x0001
         .equiv CN0PUE, 0x0000


;==============================================================================
;
; 3.  Interrupt Controller Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 3a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv INTCON1H, _INTCON1+1     ; See description for all
         .equiv INTCON1L, _INTCON1       ;  registers in sub-section below
         .equiv INTCON2H, _INTCON2+1
         .equiv INTCON2L, _INTCON2
         .equiv IFS0H, _IFS0+1
         .equiv IFS0L, _IFS0
         .equiv IFS1H, _IFS1+1
         .equiv IFS1L, _IFS1
         .equiv IFS2H, _IFS2+1
         .equiv IFS2L, _IFS2
         .equiv IEC0H, _IEC0+1
         .equiv IEC0L, _IEC0
         .equiv IEC1H, _IEC1+1
         .equiv IEC1L, _IEC1
         .equiv IEC2H, _IEC2+1
         .equiv IEC2L, _IEC2
         .equiv IPC0H, _IPC0+1
         .equiv IPC0L, _IPC0
         .equiv IPC1H, _IPC1+1
         .equiv IPC1L, _IPC1
         .equiv IPC2H, _IPC2+1
         .equiv IPC2L, _IPC2
         .equiv IPC3H, _IPC3+1
         .equiv IPC3L, _IPC3
         .equiv IPC4H, _IPC4+1
         .equiv IPC4L, _IPC4
         .equiv IPC5H, _IPC5+1
         .equiv IPC5L, _IPC5
         .equiv IPC6H, _IPC6+1
         .equiv IPC6L, _IPC6
         .equiv IPC7H, _IPC7+1
         .equiv IPC7L, _IPC7
         .equiv IPC8H, _IPC8+1
         .equiv IPC8L, _IPC8
         .equiv IPC9H, _IPC9+1
         .equiv IPC9L, _IPC9
         .equiv IPC10L, _IPC10
         .equiv INTTREGL, _INTTREG
         .equiv INTTREGH, _INTTREG+1



;------------------------------------------------------------------------------
; 3b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     INTCON1 : Interrupt Control Register 1
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv NSTDIS, 0x000F
         .equiv OVAERR, 0x000E
         .equiv OVBERR, 0x000D
         .equiv COVAERR, 0x000C
         .equiv COVBERR, 0x000B
         .equiv OVATE, 0x000A
         .equiv OVBTE, 0x0009
         .equiv COVTE, 0x0008

; Low Byte (Odd Address)
; Bit Positions defined below:
         .equiv SFTACERR, 0x0007
         .equiv DIV0ERR, 0x0006
         .equiv MATHERR, 0x0004
         .equiv ADDRERR, 0x0003
         .equiv STKERR, 0x0002
         .equiv OSCFAIL, 0x0001

;------------------------------------------------------------------------------
;     INTCON2 : Interrupt Control Register 2
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv ALTIVT, 0x000F
         .equiv DISI, 0x000E

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv INT2EP, 0x0002
         .equiv INT1EP, 0x0001
         .equiv INT0EP, 0x0000

;------------------------------------------------------------------------------
;     IFS0 : Interrupt Flag Status Register 0
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv MI2CIF, 0x000E
         .equiv SI2CIF, 0x000D
         .equiv NVMIF, 0x000C
         .equiv ADIF, 0x000B
         .equiv U1TXIF, 0x000A
         .equiv U1RXIF, 0x0009
         .equiv SPI1IF, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv T2IF, 0x0006
         .equiv T1IF, 0x0003
         .equiv OC1IF, 0x0002
         .equiv INT0IF, 0x0000

;------------------------------------------------------------------------------
;     IFS1 : Interrupt Flag Status Register 1
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv AC2IF, 0x000E
         .equiv AC1IF, 0x000D
	 .equiv CNIF , 0x000B

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv PWM2IF, 0x0004
        .equiv PWM1IF, 0x0003
        .equiv PWMEVIF, 0x0002
        .equiv INT2IF, 0x0001
        .equiv INT1IF, 0x0000

;------------------------------------------------------------------------------
;     IFS2 : Interrupt Flag Status Register 2
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
	.equiv ADCP3IF, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
	 .equiv ADCP2IF, 0x0007
	 .equiv ADCP1IF, 0x0006
	 .equiv ADCP0IF, 0x0005

;------------------------------------------------------------------------------
;     IEC0 : Interrupt Enable Control Register 0
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv MI2CIE, 0x000E
         .equiv SI2CIE, 0x000D
         .equiv NVMIE, 0x000C
         .equiv ADIE, 0x000B
         .equiv U1TXIE, 0x000A
         .equiv U1RXIE, 0x0009
         .equiv SPI1IE, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv T2IE, 0x0006
         .equiv T1IE, 0x0003
         .equiv OC1IE, 0x0002
         .equiv INT0IE, 0x0000

;------------------------------------------------------------------------------
;     IEC1 : Interrupt Enable Control Register 1
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
        .equiv AC2IE, 0x000E
        .equiv AC1IE, 0x000D
	.equiv CNIE,  0x000B

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv PWM2IE, 	0x0004
        .equiv PWM1IE, 	0x0003
        .equiv PWMEVIE, 0x0002
        .equiv INT2IE, 	0x0001
        .equiv INT1IE, 	0x0000

;------------------------------------------------------------------------------
;     IEC2 : Interrupt Enable Control Register 2
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
        .equiv ADCP3IE, 0x0008 

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv ADCP2IE, 0x0007 
        .equiv ADCP1IE, 0x0006 
        .equiv ADCP0IE, 0x0005 

;------------------------------------------------------------------------------
;     IPC0 : Interrupt Priority Control Register 0
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv T1IP2, 	0x000E
         .equiv T1IP1, 	0x000D
         .equiv T1IP0, 	0x000C
         .equiv OC1IP2, 0x000A
         .equiv OC1IP1, 0x0009
         .equiv OC1IP0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv INT0IP2, 0x0002
         .equiv INT0IP1, 0x0001
         .equiv INT0IP0, 0x0000

;------------------------------------------------------------------------------
;     IPC1 : Interrupt Priority Control Register 1
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv T2IP2, 0x000A
         .equiv T2IP1, 0x0009
         .equiv T2IP0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:

;------------------------------------------------------------------------------
;     IPC2 : Interrupt Priority Control Register 2
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv ADIP2, 0x000E
         .equiv ADIP1, 0x000D
         .equiv ADIP0, 0x000C
         .equiv U1TXIP2, 0x000A
         .equiv U1TXIP1, 0x0009
         .equiv U1TXIP0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv U1RXIP2, 0x0006
         .equiv U1RXIP1, 0x0005
         .equiv U1RXIP0, 0x0004
         .equiv SPI1IP2, 0x0002
         .equiv SPI1IP1, 0x0001
         .equiv SPI1IP0, 0x0000

;------------------------------------------------------------------------------
;     IPC3 : Interrupt Priority Control Register 3
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv MI2CIP2, 0x000A
         .equiv MI2CIP1, 0x0009
         .equiv MI2CIP0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv SI2CIP2, 0x0006
         .equiv SI2CIP1, 0x0005
         .equiv SI2CIP0, 0x0004
         .equiv NVMIP2, 0x0002
         .equiv NVMIP1, 0x0001
         .equiv NVMIP0, 0x0000

;------------------------------------------------------------------------------
;     IPC4 : Interrupt Priority Control Register 4
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv PWM1IP2, 0x000E
         .equiv PWM1IP1, 0x000D
         .equiv PWM1IP0, 0x000C
         .equiv PSEMIP2, 0x000A
         .equiv PSEMIP1, 0x0009
         .equiv PSEMIP0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv INT2IP2, 0x0006
         .equiv INT2IP1, 0x0005
         .equiv INT2IP0, 0x0004
         .equiv INT1IP2, 0x0002
         .equiv INT1IP1, 0x0001
         .equiv INT1IP0, 0x0000

;------------------------------------------------------------------------------
;     IPC5 : Interrupt Priority Control Register 5
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv PWM2IP2, 0x0002
         .equiv PWM2IP1, 0x0001
         .equiv PWM2IP0, 0x0000

;------------------------------------------------------------------------------
;     IPC6 : Interrupt Priority Control Register 6
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
	.equiv CNIP2,	0x000E
	.equiv CNIP1,	0x000D
	.equiv CNIP0,	0x000C



;------------------------------------------------------------------------------
;     IPC7 : Interrupt Priority Control Register 7
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv AC2IP2, 0x000A
         .equiv AC2IP1, 0x0009
         .equiv AC2IP0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv AC1IP2, 0x0006
         .equiv AC1IP1, 0x0005
         .equiv AC1IP0, 0x0004

;------------------------------------------------------------------------------
;     IPC8 : Interrupt Priority Control Register 8
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
 

;------------------------------------------------------------------------------
;     IPC9 : Interrupt Priority Control Register 9
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
	.equiv ADCP2IP2,0x000E
	.equiv ADCP2IP1,0x000D
	.equiv ADCP2IP0,0x000C
	.equiv ADCP1IP2,0x000A
	.equiv ADCP1IP1,0x0009
	.equiv ADCP1IP0,0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
	.equiv ADCP0IP2,0x0006
	.equiv ADCP0IP1,0x0005
	.equiv ADCP0IP0,0x0004

;------------------------------------------------------------------------------
;     IPC10 : Interrupt Priority Control Register 10
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:

; Low Byte (Even Address)
; Bit Positions defined below:
	.equiv ADCP3IP2,0x0002
	.equiv ADCP3IP1,0x0001
	.equiv ADCP3IP0,0x0000

;------------------------------------------------------------------------------
;     INTTREG : Interrupt Control and Status Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
	.equiv IRL3    ,0x0003
	.equiv IRL2    ,0x0002
	.equiv IRL1    ,0x0001
	.equiv IRL0    ,0x0000

; Low Byte (Even Address)
; Bit Positions defined below:
	.equiv VECNUM6 ,0x0006
	.equiv VECNUM5 ,0x0005
	.equiv VECNUM4 ,0x0004
	.equiv VECNUM3 ,0x0003
	.equiv VECNUM2 ,0x0002
	.equiv VECNUM1 ,0x0001
	.equiv VECNUM0 ,0x0000

;==============================================================================
;
; 4.  Timer Module Bit Position Definitions
;
;==============================================================================
; 4a. SFR Definitions
;------------------------------------------------------------------------------
;---------------Timer 1 Module-------------------------------------------------
         .equiv TMR1L, _TMR1
         .equiv TMR1H, _TMR1+1
         .equiv PR1L, _PR1
         .equiv PR1H, _PR1+1
         .equiv T1CONL, _T1CON                  ; See TxCON description in
         .equiv T1CONH, _T1CON+1                ;  sub-section below

;---------------Timer2/3 Module------------------------------------------------
         .equiv TMR2L, _TMR2
         .equiv TMR2H, _TMR2+1
  
 
         .equiv PR2L, _PR2
         .equiv PR2H, _PR2+1

         .equiv T2CONL, _T2CON                  ; See TxCON description in
         .equiv T2CONH, _T2CON+1                ;  sub-section below
   

;------------------------------------------------------------------------------
; 4b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     TxCON : Timer x Control Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv TON, 0x000F
         .equiv TSIDL, 0x000D

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv TGATE, 0x0006
         .equiv TCKPS1, 0x0005
         .equiv TCKPS0, 0x0004
         .equiv T32, 0x0003                ;T32 present only in T2CON
         .equiv TSYNC, 0x0002		;TSYNC present only in T1CON
         .equiv TCS, 0x0001




;==============================================================================
; 6.  Output Compare Module Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 6a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv OC1RSL, _OC1RS
         .equiv OC1RSH, _OC1RS+1
         .equiv OC1RL, _OC1R
         .equiv OC1RH, _OC1R+1
         .equiv OC1CONL, _OC1CON                ; See OCxCON description in
         .equiv OC1CONH, _OC1CON+1              ;  sub-section below
 
;------------------------------------------------------------------------------
; 6b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     OCxCON : Output Compare x Control Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv OCSIDL, 0x000D

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv OCFLT, 0x0004
         .equiv OCTSEL, 0x0003
         .equiv OCM2, 0x0002
         .equiv OCM1, 0x0001
         .equiv OCM0, 0x0000

;==============================================================================
; 7.  I2C Register Module Bit Position Definitions
;
;==============================================================================
; 7a. SFR Definitions
;------------------------------------------------------------------------------
        .equiv I2CRCVH, _I2CRCV+1
        .equiv I2CRCVL, _I2CRCV
        .equiv I2CTRNH, _I2CTRN+1
        .equiv I2CTRNL, _I2CTRN
        .equiv I2CBRGH, _I2CBRG+1
        .equiv I2CBRGL, _I2CBRG
        .equiv I2CCONH, _I2CCON+1
        .equiv I2CCONL, _I2CCON
        .equiv I2CSTATH, _I2CSTAT+1
        .equiv I2CSTATL, _I2CSTAT
        .equiv I2CADDH, _I2CADD+1
        .equiv I2CADDL, _I2CADD

;------------------------------------------------------------------------------
; 7b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;       I2CCON
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv I2CEN, 0x000F
         .equiv I2CSIDL, 0x000D
         .equiv SCLREL, 0x000C
         .equiv IPMIEN, 0x000B
         .equiv A10M  , 0x000A
         .equiv DISSLW, 0x0009
         .equiv SMEN, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv GCEN, 0x0007
         .equiv STREN, 0x0006
         .equiv ACKDT, 0x0005
         .equiv ACKEN, 0x0004
         .equiv RCEN, 0x0003
         .equiv PEN, 0x0002
         .equiv RSEN, 0x0001
         .equiv SEN, 0x0000

;------------------------------------------------------------------------------
;       I2CSTAT
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv ACKSTAT, 0x000F
         .equiv TRSTAT, 0x000E
         .equiv GCSTAT, 0x0009
         .equiv ADD10, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv IWCOL, 0x0007
         .equiv I2COV, 0x0006
         .equiv D_A, 0x0005
         .equiv P, 0x0004
         .equiv S, 0x0003
         .equiv R_W, 0x0002
         .equiv RBF, 0x0001
         .equiv TBF, 0x0000


;==============================================================================
;
; 8. UART1 Module Bit Position Definitions
;
;==============================================================================
; 8a. SFR Definitions
;------------------------------------------------------------------------------
;------------------UART 1 Module-----------------------------------------------
         .equiv U1MODEL, _U1MODE                ; See UxMODE description in
         .equiv U1MODEH, _U1MODE+1              ;  sub-section below
         .equiv U1STAL, _U1STA                  ; See UxSTA description in
         .equiv U1STAH, _U1STA+1                ;  sub-section below
         .equiv U1TXREGL, _U1TXREG
         .equiv U1TXREGH, _U1TXREG+1
         .equiv U1RXREGL, _U1RXREG
         .equiv U1RXREGH, _U1RXREG+1
         .equiv U1BRGL, _U1BRG
         .equiv U1BRGH, _U1BRG+1

;------------------------------------------------------------------------------
; 8b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     UxMODE : UART x Mode Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv UARTEN, 0x000F
         .equiv USIDL, 0x000D
         .equiv IREN, 0x000C
   	     .equiv ALTIO, 0x000A

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv WAKE, 0x0007
         .equiv LPBACK, 0x0006
         .equiv ABAUD, 0x0005
         .equiv RXINV, 0x0004
         .equiv BRGH, 0x0003
         .equiv PDSEL1, 0x0002
         .equiv PDSEL0, 0x0001
         .equiv STSEL, 0x0000

;------------------------------------------------------------------------------
;     UxSTA : UART x Status and Control Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv UTXISEL, 0x000F
         .equiv UTXIRINV, 0x000E
         .equiv UTXBRK, 0x000B
         .equiv UTXEN, 0x000A
         .equiv UTXBF, 0x0009
         .equiv TRMT, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv URXISEL1, 0x0007
         .equiv URXISEL0, 0x0006
         .equiv ADDEN, 0x0005
         .equiv RIDLE, 0x0004
         .equiv PERR, 0x0003
         .equiv FERR, 0x0002
         .equiv OERR, 0x0001
         .equiv URXDA, 0x0000


;==============================================================================
;
; 9. Serial Peripheral Interface Module Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.      (SPIx)
;==============================================================================
; 9a. SFR Definitions
;------------------------------------------------------------------------------
;------------------SPI 1 Module------------------------------------------------
         .equiv SPI1STATL, _SPI1STAT      ; See SPIxSTAT description in
         .equiv SPI1STATH, _SPI1STAT+1    ;  sub-section below
         .equiv SPI1CON1L, _SPI1CON1      ; See SPIxCON1 description in
         .equiv SPI1CON1H, _SPI1CON1+1    ;  sub-section below
         .equiv SPI1CON2L, _SPI1CON2      ; See SPIxCON2 description in
         .equiv SPI1CON2H, _SPI1CON2+1    ;  sub-section below
         .equiv SPI1BUFL, _SPI1BUF
         .equiv SPI1BUFH, _SPI1BUF+1


;------------------------------------------------------------------------------
; 9b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     SPIxSTAT : SPI x Status register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv SPIEN, 0x000F
         .equiv SPISIDL, 0x000D
         .equiv BUFELM2, 0x000A
         .equiv BUFELM1, 0x0009
         .equiv BUFELM0, 0x0008


; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv SPIROV, 0x0006
         .equiv SPITBF, 0x0001
         .equiv SPIRBF, 0x0000


;------------------------------------------------------------------------------
;     SPIxCON1 : SPI x Control Register 1
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
        .equiv DISSCK,  0x000C
        .equiv DISSDO,  0x000B    
        .equiv MODE16,  0x000A     
        .equiv SMP,     0x0009
        .equiv CKE,     0x0008


; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv SSEN,    0x0007
        .equiv CKP,     0x0006
        .equiv MSTEN,   0x0005
        .equiv SPRE2,   0x0004
        .equiv SPRE1,   0x0003
        .equiv SPRE0,   0x0002
        .equiv PPRE1,   0x0001
        .equiv PPRE0,   0x0000


;------------------------------------------------------------------------------
;     SPIxCON2 : SPI x Control Register 2
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
        .equiv FRMEN,   0x000F
        .equiv SPIFSD,  0x000E
        .equiv FRMPOL,  0x000D

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv FRMDLY,  0x0001
        .equiv ENHBUF,  0x0000

;------------------------------------------------------------------------------
;     U1TXREG : UART1 Transmit Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
       ;.equiv UTX8,    0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
       .equiv UTXREG7, 0x0007
       .equiv UTXREG6, 0x0006
       .equiv UTXREG5, 0x0005
       .equiv UTXREG4, 0x0004
       .equiv UTXREG3, 0x0003
       .equiv UTXREG2, 0x0002
       .equiv UTXREG1, 0x0001
       .equiv UTXREG0, 0x0000


;------------------------------------------------------------------------------
;     U1RXREG : UART1 Receive Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
       ;.equiv URX8,   0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
       .equiv URXREG7, 0x0007
       .equiv URXREG6, 0x0006
       .equiv URXREG5, 0x0005
       .equiv URXREG4, 0x0004
       .equiv URXREG3, 0x0003
       .equiv URXREG2, 0x0002
       .equiv URXREG1, 0x0001
       .equiv URXREG0, 0x0000

;==============================================================================
;
; 10.  Port A: General Purpose I/O Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 10a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv TRISAH, _TRISA+1
         .equiv PORTAH, _PORTA+1
         .equiv LATAH, _LATA+1

;------------------------------------------------------------------------------
; 10b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     TRISA : Port A Data Direction Control Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv TRISA9, 0x0009

;     PORTA : Read Port A Pin / Write Port B Latch Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv RA9, 0x0009

;     LATA : Read / Write Port A Latch Register
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv LATA9, 0x0009

;==============================================================================
;
; 11.  Port B: General Purpose I/O Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 11a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv TRISBL, _TRISB                  ; See all SFR descriptions in
                                                ;  sub-section below
         .equiv PORTBL, _PORTB
         .equiv LATBL, _LATB

;------------------------------------------------------------------------------
; 11b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     TRISB : Port B Data Direction Control Register

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv TRISB7, 0x0007
         .equiv TRISB6, 0x0006
         .equiv TRISB5, 0x0005
         .equiv TRISB4, 0x0004
         .equiv TRISB3, 0x0003
         .equiv TRISB2, 0x0002
         .equiv TRISB1, 0x0001
         .equiv TRISB0, 0x0000

;     PORTB : Read Port B Pin / Write Port B Latch Register

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv RB7, 0x0007
         .equiv RB6, 0x0006
         .equiv RB5, 0x0005
         .equiv RB4, 0x0004
         .equiv RB3, 0x0003
         .equiv RB2, 0x0002
         .equiv RB1, 0x0001
         .equiv RB0, 0x0000

;     LATB : Read / Write Port B Latch Register

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv LATB7, 0x0007
         .equiv LATB6, 0x0006
         .equiv LATB5, 0x0005
         .equiv LATB4, 0x0004
         .equiv LATB3, 0x0003
         .equiv LATB2, 0x0002
         .equiv LATB1, 0x0001
         .equiv LATB0, 0x0000

;==============================================================================
;
; 12.  Port D: General Purpose I/O Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 12a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv TRISDL, _TRISD                  ; See all SFR descriptions in
                                                ;  sub-section below
         .equiv PORTDL, _PORTD
         .equiv LATDL, _LATD


;------------------------------------------------------------------------------
; 12b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     TRISD : Port D Data Direction Control Register
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv TRISD0, 0x0000

;     PORTD : Read Port D Pin / Write Port D Latch Register
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv RD0, 0x0000

;     LATD : Read / Write Port D Latch Register
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv LATD0, 0x0000

;==============================================================================
;
; 13.  Port E: General Purpose I/O Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 13a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv TRISEL, _TRISE                  ; See all SFR descriptions in
         .equiv PORTEL, _PORTE                  ;  sub-section below
         .equiv LATEL, _LATE

;------------------------------------------------------------------------------
; 13b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     TRISE : Port E Data Direction Control Register
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv TRISE7, 0x0007
         .equiv TRISE6, 0x0006
         .equiv TRISE5, 0x0005
         .equiv TRISE4, 0x0004
         .equiv TRISE3, 0x0003
         .equiv TRISE2, 0x0002
         .equiv TRISE1, 0x0001
         .equiv TRISE0, 0x0000

;     PORTE : Read Port E Pin / Write Port E Latch Register
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv RE7, 0x0007
         .equiv RE6, 0x0006
         .equiv RE5, 0x0005
         .equiv RE4, 0x0004
         .equiv RE3, 0x0003
         .equiv RE2, 0x0002
         .equiv RE1, 0x0001
         .equiv RE0, 0x0000

;     LATE : Read / Write Port E Latch Register
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv LATE7, 0x0007
         .equiv LATE6, 0x0006
         .equiv LATE5, 0x0005
         .equiv LATE4, 0x0004
         .equiv LATE3, 0x0003
         .equiv LATE2, 0x0002
         .equiv LATE1, 0x0001
         .equiv LATE0, 0x0000

;==============================================================================
;
; 14.  Port F: General Purpose I/O Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 14a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv TRISFL, _TRISF                  ; See all SFR descriptions in
         .equiv TRISFH, _TRISF+1                ;  sub-section below
         .equiv PORTFL, _PORTF
         .equiv PORTFH, _PORTF+1
         .equiv LATFL, _LATF
         .equiv LATFH, _LATF+1

;------------------------------------------------------------------------------
; 14b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     TRISF : Port F Data Direction Control Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv TRISF8, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv TRISF7, 0x0007
         .equiv TRISF6, 0x0006

;     PORTF : Read Port F Pin / Write Port F Latch Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv RF8, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv RF7, 0x0007
         .equiv RF6, 0x0006

;     LATF : Read / Write Port F Latch Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv LATF8, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv LATF7, 0x0007
         .equiv LATF6, 0x0006

;==============================================================================
;
; 16.  A/D Module Bit Position Definitions
;
;==============================================================================
; 16a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv ADCBUF0L, _ADCBUF0
         .equiv ADCBUF0H, _ADCBUF0+1
         .equiv ADCBUF1L, _ADCBUF1
         .equiv ADCBUF1H, _ADCBUF1+1
         .equiv ADCBUF2L, _ADCBUF2
         .equiv ADCBUF2H, _ADCBUF2+1
         .equiv ADCBUF3L, _ADCBUF3
         .equiv ADCBUF3H, _ADCBUF3+1
         .equiv ADCBUF4L, _ADCBUF4
         .equiv ADCBUF4H, _ADCBUF4+1
         .equiv ADCBUF5L, _ADCBUF5
         .equiv ADCBUF5H, _ADCBUF5+1
         .equiv ADCBUF6L, _ADCBUF6
         .equiv ADCBUF6H, _ADCBUF6+1
         .equiv ADCBUF7L, _ADCBUF7
         .equiv ADCBUF7H, _ADCBUF7+1
         .equiv ADCONL, _ADCON                ; See ADCONL through ADPCFGH
         .equiv ADCONH, _ADCON+1              ;  description in sub-section below
         .equiv ADPCFGL, _ADPCFG
         .equiv ADPCFGH, _ADPCFG+1
         .equiv ADSTATL, _ADSTAT
         .equiv ADSTATH, _ADSTAT+1
         .equiv ADBASEL, _ADBASE
         .equiv ADBASEH, _ADBASE+1
         .equiv ADCPC0L, _ADCPC0
         .equiv ADCPC0H, _ADCPC0+1
         .equiv ADCPC1L, _ADCPC1
         .equiv ADCPC1H, _ADCPC1+1


;------------------------------------------------------------------------------
; 16b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     ADCON : A/D Control Register 1
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv ADON, 	0x000F
         .equiv ADSIDL, 0x000D
         .equiv GSWTRG, 0x000A
         .equiv FORM, 	0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv EIE, 	0x0007
         .equiv ORDER, 	0x0006
         .equiv SEQSAMP,0x0005
         .equiv ADCS2, 	0x0002
         .equiv ADCS1, 	0x0001
         .equiv ADCS0, 	0x0000

;------------------------------------------------------------------------------
;       ADPCFG
;------------------------------------------------------------------------------
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv PCFG7, 0x0007
         .equiv PCFG6, 0x0006
         .equiv PCFG5, 0x0005
         .equiv PCFG4, 0x0004
         .equiv PCFG3, 0x0003
         .equiv PCFG2, 0x0002
         .equiv PCFG1, 0x0001
         .equiv PCFG0, 0x0000

;------------------------------------------------------------------------------
;     ADSTAT
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv P2RDY, 0x0002
         .equiv P1RDY, 0x0001
         .equiv P0RDY, 0x0000

;------------------------------------------------------------------------------
;     ADCPC0
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
        .equiv IRQEN1, 	0x000F
        .equiv PEND1,	0x000E
	.equiv SWTRG1, 	0x000D
        .equiv TRGSRC14, 0x000C
        .equiv TRGSRC13, 0x000B
        .equiv TRGSRC12, 0x000A
        .equiv TRGSRC11, 0x0009
        .equiv TRGSRC10, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv IRQEN0, 	0x0007
        .equiv PEND0, 	0x0006
        .equiv SWTRG0, 	0x0005
        .equiv TRGSRC04, 0x0004
        .equiv TRGSRC03, 0x0003
        .equiv TRGSRC02, 0x0002
        .equiv TRGSRC01, 0x0001
        .equiv TRGSRC00, 0x0000


;------------------------------------------------------------------------------
;     ADCPC1
;------------------------------------------------------------------------------
; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv IRQEN2, 	0x0007
        .equiv PEND2, 	0x0006
        .equiv SWTRG2, 	0x0005
        .equiv TRGSRC24, 0x0004
        .equiv TRGSRC23, 0x0003
        .equiv TRGSRC22, 0x0002
        .equiv TRGSRC21, 0x0001
        .equiv TRGSRC20, 0x0000


;==============================================================================
;
; 17.   Power Supply PWM Module Bit Position Definitions for SFRs
;       & SFR High/Low byte definitions. 
;==============================================================================
; 17a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv PTCONL, _PTCON               ; See description for all registers
         .equiv PTCONH, _PTCON+1             ;  except PDCx registers, in section 8b
         .equiv PTPERL, _PTPER
         .equiv PTPERH, _PTPER+1
         .equiv PDCL, _PTMR
         .equiv PDCH, _PTMR+1
         .equiv SEVTCMPL, _SEVTCMP
         .equiv SEVTCMPH, _SEVTCMP+1
         
	 .equiv PWMCON1L, 	_PWMCON1
         .equiv PWMCON1H, 	_PWMCON1+1
         .equiv IOCON1L, 	_IOCON1
         .equiv IOCON1H, 	_IOCON1+1
         .equiv FCLCON1L,	_FCLCON1
         .equiv FCLCON1H, 	_FCLCON1+1
         .equiv PDC1L, 		_PDC1
         .equiv PDC1H, 		_PDC1+1
         .equiv PHASE1L, 	_PHASE1
         .equiv PHASE1H, 	_PHASE1+1
         .equiv DTR1L, 		_DTR1
         .equiv DTR1H, 		_DTR1+1
	 .equiv ALTDTR1L, 	_ALTDTR1
	 .equiv ALTDTR1H, 	_ALTDTR1+1
         .equiv TRIG1L, 	_TRIG1
         .equiv TRIG1H, 	_TRIG1+1
         .equiv TRGCON1L, 	_TRGCON1
         .equiv TRGCON1H, 	_TRGCON1+1
	 .equiv LEBCON1L,	_LEBCON1
	 .equiv LEBCON1H,	_LEBCON1+1
         
	 .equiv PWMCON2L, 	_PWMCON2
         .equiv PWMCON2H, 	_PWMCON2+1
         .equiv IOCON2L, 	_IOCON2
         .equiv IOCON2H, 	_IOCON2+1
         .equiv FCLCON2L, 	_FCLCON2
         .equiv FCLCON2H, 	_FCLCON2+1
         .equiv PDC2L, 		_PDC2
         .equiv PDC2H, 		_PDC2+1
         .equiv PHASE2L, 	_PHASE2
         .equiv PHASE2H, 	_PHASE2+1
         .equiv DTR2L, 		_DTR2
         .equiv DTR2H,		_DTR2+1
	 .equiv ALTDTR2L, 	_ALTDTR2
	 .equiv ALTDTR2H, 	_ALTDTR2+1
         .equiv TRIG2L,		_TRIG2
         .equiv TRIG2H,		_TRIG2+1
         .equiv TRGCON2L, 	_TRGCON2
         .equiv TRGCON2H,	_TRGCON2+1
	 .equiv LEBCON2L,	_LEBCON2
	 .equiv LEBCON2H,	_LEBCON2+1
         
	 
         
	 


;------------------------------------------------------------------------------
; 17b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     PTCON : PWM Timebase Control Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv PTEN, 0x000F
         .equiv PTSIDL, 0x000D
         .equiv SESTAT, 0x000C
         .equiv SEIEN, 0x000B
         .equiv EIPU, 0x000A
         .equiv SYNCPOL, 0x0009
         .equiv SYNCOEN, 0x0008


; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv SYNCEN, 0x0007
        .equiv SYNCSRC2, 0x0006
        .equiv SYNCSRC1, 0x0005
        .equiv SYNCSRC0, 0x0004
        .equiv SEVTPS3, 0x0003
        .equiv SEVTPS2, 0x0002
        .equiv SEVTPS1, 0x0001
        .equiv SEVTPS0, 0x0000

;------------------------------------------------------------------------------
;     PWMCON 1-4
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv FLTSTAT, 0x000F
         .equiv CLSTAT, 0x000E
         .equiv TRGSTAT, 0x000D
         .equiv FLTIEN, 0x000C
         .equiv CLIEN, 0x000B
         .equiv TRGIEN, 0x000A
         .equiv ITB, 0x0009
         .equiv MDCS, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv DTC1, 0x0007
        .equiv DTC0, 0x0006
        .equiv XPRES, 0x0001
        .equiv IUE, 0x0000

;------------------------------------------------------------------------------
;     IOCON 1-4
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv PENH, 0x000F
         .equiv PENL, 0x000E
         .equiv POLH, 0x000D
         .equiv POLL, 0x000C
         .equiv PMOD1, 0X000B
         .equiv PMOD0, 0X000A
         .equiv OVRENH, 0x0009
         .equiv OVRENL, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv OVRDAT1, 0x0007
         .equiv OVRDAT0, 0x0006
         .equiv FLTDAT1, 0x0005
         .equiv FLTDAT0, 0x0004
         .equiv CLDAT1, 0x0003
         .equiv CLDAT0, 0x0002
         .equiv OSYNC, 0x0000

;------------------------------------------------------------------------------
;     FCLCON 1-4
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv CLSRC3, 0x000C
         .equiv CLSRC2, 0x000B
         .equiv CLSRC1, 0x000A
         .equiv CLSRC0, 0x0009
         .equiv CLPOL, 0x0008


; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv CLMODE, 0x0007
         .equiv FLTSRC3, 0x0006
         .equiv FLTSRC2, 0X0005
         .equiv FLTSRC1, 0X0004
         .equiv FLTSRC0, 0x0003
         .equiv FLTPOL, 0x0002
         .equiv FLTMOD1, 0x0001
         .equiv FLTMOD0, 0x0000

;------------------------------------------------------------------------------
;     TRGCON 1-4
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv TRIGDIV2, 0x000F
         .equiv TRIGDIV1, 0x000E
         .equiv TRIGDIV0, 0x000D

; Low Byte (Even Address)
; Bit Positions defined below:
         
         .equiv TRGSTRT5, 0x0005
         .equiv TRGSTRT4, 0x0004
         .equiv TRGSTRT3, 0x0003
         .equiv TRGSTRT2, 0x0002
         .equiv TRGSTRT1, 0x0001
         .equiv TRGSTRT0, 0x0000

;------------------------------------------------------------------------------
;     LEBCON 1-4
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
	.equiv	PHR,	0x000F
	.equiv	PHF,	0x000E
	.equiv	PLR,	0x000D
	.equiv 	PLF,	0x000C
	.equiv 	FLTLBEN,0x000B
	.equiv	CLLEBEN,0x000A
	.equiv	LEB6,	0x0009
	.equiv 	LEB5,	0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
	
	.equiv	LEB4,	0x0007
	.equiv	LEB3,	0x0006
	.equiv	LEB2,	0x0005
	.equiv	LEB1,	0x0004
	.equiv	LEB0,	0x0003

;==============================================================================
; 18. Analog Comparator Control Register Map
;
;==============================================================================
; 18a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv CMPCON1L, _CMPCON1
         .equiv CMPCON1H, _CMPCON1+1
         .equiv CMPCON2L, _CMPCON2
         .equiv CMPCON2H, _CMPCON2+1

;------------------------------------------------------------------------------
; 18b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
; CMPCON 1,2,3,4
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv CMPON, 	0x000F
         .equiv CMPSIDL,0x000D

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv INSEL1, 	0x0007
        .equiv INSEL0, 	0x0006
        .equiv EXTREF, 	0x0005
        .equiv CMPSTAT, 0x0003
        .equiv CMPPOL, 	0x0001
        .equiv RANGE, 	0x0000

;==============================================================================
; 19. System Integration Block Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions.
;==============================================================================
; 19a.    SFR Definitions
;------------------------------------------------------------------------------
        .equiv RCONL, 	_RCON
        .equiv RCONH, 	_RCON+1
        .equiv OSCCONL, _OSCCON
        .equiv OSCCONH, _OSCCON+1
        .equiv CLKDIVL, _CLKDIV
        .equiv CLKDIVH, _CLKDIV+1
        .equiv OSCTUNL, _OSCTUN
        .equiv OSCTUNH, _OSCTUN+1
        .equiv OSCTUN2L,_OSCTUN2
        .equiv OSCTUN2H,_OSCTUN2+1

;------------------------------------------------------------------------------
; 19b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;       RCON
; High Byte (Odd Address)
; Bit Positions defined below:
        .equiv TRAPR,	0x000F
        .equiv IOPUWR, 	0x000E

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv EXTR, 	0x0007
        .equiv SWR, 	0x0006
        .equiv SWDTEN, 	0x0005
        .equiv WDTO, 	0x0004
        .equiv SLEEP, 	0x0003
        .equiv IDLE, 	0x0002
        .equiv POR, 	0x0000

;------------------------------------------------------------------------------
;       OSCCON
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
        .equiv COSC2, 0x000E
        .equiv COSC1, 0x000D
        .equiv COSC0, 0x000C
        .equiv NOSC2, 0x000A
        .equiv NOSC1, 0x0009
        .equiv NOSC0, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv CLKLOCK, 0x0007
        .equiv LOCK, 	0x0005
	.equiv PRCDEN,	0x0004
        .equiv CF, 	0x0003
        .equiv TSEQEN, 	0x0002
        .equiv OSWEN, 	0x0000

;------------------------------------------------------------------------------
;       CLKDIV
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
;        .equiv ROI, 0x000F
;        .equiv DOZE2, 0x000E
;        .equiv DOZE1, 0x000D
;        .equiv DOZE0, 0x000C
;        .equiv DOZEN, 0x000B

;------------------------------------------------------------------------------
;       OSCTUN
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
	.equiv TSEQ33,0x000F
   	.equiv TSEQ32,0x000E
   	.equiv TSEQ31,0x000D
   	.equiv TSEQ30,0x000C
   	.equiv TSEQ23,0x000B
   	.equiv TSEQ22,0x000A
   	.equiv TSEQ21,0x0009
   	.equiv TSEQ20,0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv TSEQ13,0x0007
        .equiv TSEQ12,0x0006
        .equiv TSEQ11,0x0005
        .equiv TSEQ10,0x0004
        .equiv TUN3,0x0003
        .equiv TUN2,0x0002
        .equiv TUN1,0x0001
        .equiv TUN0,0x0000

;------------------------------------------------------------------------------
;       OSCTUN2
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
	.equiv TSEQ73,0x000F
	.equiv TSEQ72,0x000E
	.equiv TSEQ71,0x000D
	.equiv TSEQ70,0x000C
	.equiv TSEQ63,0x000B
	.equiv TSEQ62,0x000A
	.equiv TSEQ61,0x0009
	.equiv TSEQ60,0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
        .equiv TSEQ53,0x0007
        .equiv TSEQ52,0x0006
        .equiv TSEQ51,0x0005
        .equiv TSEQ50,0x0004
        .equiv TSEQ43,0x0003
        .equiv TSEQ42,0x0002
        .equiv TSEQ41,0x0001
        .equiv TSEQ40,0x0000

;==============================================================================
;
; 20.  Non Volatile Memory Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions. (NVM)
;==============================================================================
; 20a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv NVMCONL, _NVMCON                ; See NVMCON description in
         .equiv NVMCONH, _NVMCON+1              ;  sub-section below
         .equiv NVMADRL, _NVMADR
         .equiv NVMADRH, _NVMADR+1
         .equiv NVMADRUL, _NVMADRU
         .equiv NVMADRUH, _NVMADRU+1
         .equiv NVMKEYL, _NVMKEY
         .equiv NVMKEYH, _NVMKEY+1

;------------------------------------------------------------------------------
; 20b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;     NVMCON : Non Volatile Memory Control Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv WR, 0x000F
         .equiv WREN, 0x000E
         .equiv WRERR, 0x000D
         .equiv TWRI, 0x0008

; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv PROGOP6, 0x0006
         .equiv PROGOP5, 0x0005
         .equiv PROGOP4, 0x0004
         .equiv PROGOP3, 0x0003
         .equiv PROGOP2, 0x0002
         .equiv PROGOP1, 0x0001
         .equiv PROGOP0, 0x0000


;==============================================================================
;
; 21. Peripheral Module Disable Bit Position Definitions for SFRs
;     & SFR High/Low byte definitions. (PMD)
;==============================================================================
; 21a. SFR Definitions
;------------------------------------------------------------------------------
         .equiv PMD1L, _PMD1                    ; See bit descrpitions below
         .equiv PMD1H, _PMD1+1                  ;  for all files
         .equiv PMD2L, _PMD2
         .equiv PMD2H, _PMD2+1
         .equiv PMD3L, _PMD3
         .equiv PMD3H, _PMD3+1

;------------------------------------------------------------------------------
; 21b. Bit Position Definitions for some SFRs
;------------------------------------------------------------------------------
;  PMD1: Peripheral Module Disable 1 Register
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv T3MD, 0x000D
         .equiv T2MD, 0x000C
         .equiv T1MD, 0x000B
         .equiv PWMMD, 0x0009
         
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv I2CMD, 0x0007
         .equiv U1MD, 0x0005
         .equiv SPI1MD, 0x0003
         .equiv ADCMD, 0x0000

;------------------------------------------------------------------------------
;  PMD2: Peripheral Module Disable 2 Register
;------------------------------------------------------------------------------
; Low Byte (Even Address)
; Bit Positions defined below:
         .equiv OC2MD, 0x0001
         .equiv OC1MD, 0x0000

;------------------------------------------------------------------------------
;  PMD3: Peripheral Module Disable 3 Register
;------------------------------------------------------------------------------
; High Byte (Odd Address)
; Bit Positions defined below:
         .equiv CMP_PSMD, 0x000B

; Low Byte (Even Address)
; Bit Positions defined below:

;==============================================================================
;
; 22. Useful constants that ease assembly-level programming
;
;==============================================================================
         .equiv SLEEP_MODE, 0x0000
         .equiv IDLE_MODE, 0x0001
;------------------------------------------------------------------------------

;==============================================================================
;
; 23. Macros and Fuse Configuration Definitions
;
;==============================================================================
; Notes:
;    1. Use the following fuse configuration settings by calling the "config"
;       macro(defined at the end of this section)or directly in assembly source
;       code.
;    2. Configuration Fuses exist in Program Space and their locations are
;       defined in the device linker script.
;==============================================================================
;------------------------------------------------------------------------------
; FOSC: Oscillator Selection Fuse
;------------------------------------------------------------------------------

    .equiv CSW_FSCM_OFF,    0xFFFF
	.equiv CSW_ON_FSCM_OFF, 0xFF7F
	.equiv CSW_FSCM_ON,     0xFF3F
	.equiv FRC_LO_RANGE,    0xFFDF
	.equiv FRC_HI_RANGE,    0xFFFF
	.equiv OSC2_IO,         0xFFFB
	.equiv OSC2_CLKO,       0xFFFF
	.equiv HS_EC_DIS,       0xFFFF
	.equiv EC,              0xFFFC
	.equiv HS,              0xFFFE


;------------------------------------------------------------------------------
; FOSCSEL: Oscillator Source Selection Fuse
;------------------------------------------------------------------------------

	.equiv FRC,		0xFFFC
	.equiv FRC_PLL,		0xFFFD
	.equiv PRIOSC,		0xFFFE
	.equiv PRIOSC_PLL,	0xFFFF

;------------------------------------------------------------------------------
; FWDT: Watch Dog Timer Configuration Fuse
;------------------------------------------------------------------------------
         .equiv	WDT_ON,    0xFF7F
	     .equiv	WDT_OFF,   0xFFFF
	     .equiv	WDTPSA_1,  0xFFEF
	     .equiv	WDTPSA_4,  0xFFFF
         .equiv WDTPSB_1, 0xFFF0
         .equiv WDTPSB_2, 0xFFF1
         .equiv WDTPSB_3, 0xFFF2
         .equiv WDTPSB_4, 0xFFF3
         .equiv WDTPSB_5, 0xFFF4
         .equiv WDTPSB_6, 0xFFF5
         .equiv WDTPSB_7, 0xFFF6
         .equiv WDTPSB_8, 0xFFF7
         .equiv WDTPSB_9, 0xFFF8
         .equiv WDTPSB_10, 0xFFF9
         .equiv WDTPSB_11, 0xFFFA
         .equiv WDTPSB_12, 0xFFFB
         .equiv WDTPSB_13, 0xFFFC
         .equiv WDTPSB_14, 0xFFFD
         .equiv WDTPSB_15, 0xFFFE
         .equiv WDTPSB_16, 0xFFFF

;------------------------------------------------------------------------------
; FPOR: Power-on Reset Fuse
;------------------------------------------------------------------------------
    .equiv PWRT_OFF,       0xFFF8
	.equiv PWRT_2,         0xFFF9
	.equiv PWRT_4,         0xFFFA
	.equiv PWRT_8,         0xFFFB
	.equiv PWRT_16,        0xFFFC
	.equiv PWRT_32,        0xFFFD
	.equiv PWRT_64,        0xFFFE
	.equiv PWRT_128,       0xFFFF

;------------------------------------------------------------------------------
; FGS: Genneral (Code) Segment Fuse
;------------------------------------------------------------------------------
         .equiv CODE_PROT_OFF, 0xFFFF
         .equiv CODE_PROT_ON,  0xFFFD
         .equiv GWRP_OFF,      0xFFFF
         .equiv GWRP_ON,       0xFFFE

;------------------------------------------------------------------------------
; FBS: Boot (Code) Segment Fuse
;------------------------------------------------------------------------------
	.equiv NO_BOOT_CODE,         0xFFFF
	.equiv STRD_SMALL_BOOT_CODE, 0xFFFD
	.equiv STRD_MEDIUM_BOOT_CODE,0xFFFB

	.equiv HIGH_SMALL_BOOT_CODE, 0xFFF5
	.equiv HIGH_MEDIUM_BOOT_CODE,0xFFF3

	.equiv WR_PROT_BOOT_OFF,     0xFFFF
	.equiv WR_PROT_BOOT_ON,      0xFFFE


;------------------------------------------------------------------------------
; Setting configuration fuses
;------------------------------------------------------------------------------
; Setting configuration fuses using macros:
;==========================================
; The following macro named "config" can be used to set configuration fuses:
        .macro config REG, VALUE
        .section \REG.sec, code
        .global \REG
\REG:   .pword \VALUE
        .endm
; For e.g., to set the FOSC fuse using the macro above, the following line of
; code can be pasted at the only at the beginning of the assembly source code,
; immediately below the ".include" directive.
;
;        config __FOSC, CSW_FSCM_ON & FRC & FRC_HI_RANGE
;
; This would enable the internal FRC oscillator to its lower range of
; operation, and further enable clock switching and fail-safe clock monitoring.
;
; Similarly, to set the FPOR fuse, paste the following :
;
;        config __FPOR, PWRT_64 & MCLR_DIS
;
; This would enable Brown-out Reset at 2.7 Volts and initialize the Power-up
; timer to 64 milliseconds and configure the use of the MCLR pin for I/O.
; Given below, is a list of settings valid to each of the fuses:
; (Paste the ones relevant to your application at the beginning of the assembly
; source, immediately below the ".include" directive.)
;
;                FOSC:
;               ======
;               config __FOSC, CSW_FSCM_OFF & FRC_HI_RANGE
;               config __FOSC, CSW_FSCM_OFF & FRC_LO_RANGE
;               config __FOSC, CSW_FSCM_OFF & OSC2_IO & HS_EC_DIS
;               config __FOSC, CSW_FSCM_OFF & OSC2_IO & EC
;               config __FOSC, CSW_FSCM_OFF & OSC2_IO & HS
;               config __FOSC, CSW_FSCM_OFF & OSC2_CLKO & HS_EC_DIS
;               config __FOSC, CSW_FSCM_OFF & OSC2_CLKO & EC
;               config __FOSC, CSW_FSCM_OFF & OSC2_CLKO & HS
;               config __FOSC, CSW_ON_FSCM_OFF & FRC_HI_RANGE
;               config __FOSC, CSW_ON_FSCM_OFF & FRC_LO_RANGE
;               config __FOSC, CSW_ON_FSCM_OFF & OSC2_IO & HS_EC_DIS
;               config __FOSC, CSW_ON_FSCM_OFF & OSC2_IO & EC
;               config __FOSC, CSW_ON_FSCM_OFF & OSC2_IO & HS
;               config __FOSC, CSW_ON_FSCM_OFF & OSC2_CLKO & HS_EC_DIS
;               config __FOSC, CSW_ON_FSCM_OFF & OSC2_CLKO & EC
;               config __FOSC, CSW_ON_FSCM_OFF & OSC2_CLKO & HS
;               config __FOSC, CSW_FSCM_ON & FRC_HI_RANGE
;               config __FOSC, CSW_FSCM_ON & FRC_LO_RANGE
;               config __FOSC, CSW_FSCM_ON & OSC2_IO & HS_EC_DIS
;               config __FOSC, CSW_FSCM_ON & OSC2_IO & EC
;               config __FOSC, CSW_FSCM_ON & OSC2_IO & HS
;               config __FOSC, CSW_FSCM_ON & OSC2_CLKO & HS_EC_DIS
;               config __FOSC, CSW_FSCM_ON & OSC2_CLKO & EC
;               config __FOSC, CSW_FSCM_ON & OSC2_CLKO & HS
;		
;		FOSCSEL:
;		========
;		config __FOSCSEL,FRC
;		config __FOSCSEL,FRC_PLL
;		config __FOSCSEL,PRIOSC
;		config __FOSCSEL,PRIOSC_PLL
;
;              
;               FWDT
;               =====
;              config __FWDT,WDT_OFF
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_1
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_2
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_3
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_4
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_5
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_6
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_7
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_8
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_9
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_10
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_11
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_12
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_13
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_14
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_15
;              config __FWDT,WDT_ON & WDTPSA_1 & WDTPSB_16
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_1
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_2
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_3
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_4
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_5
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_6
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_7
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_8
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_9
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_10
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_11
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_12
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_13
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_14
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_15
;              config __FWDT,WDT_ON & WDTPSA_4 & WDTPSB_16
;
;               FPOR
;               ========
;
;               config __FPOR, PWRT_OFF
;               config __FPOR, PWRT_2
;               config __FPOR, PWRT_4
;               config __FPOR, PWRT_8
;               config __FPOR, PWRT_16
;               config __FPOR, PWRT_32
;               config __FPOR, PWRT_64
;               config __FPOR, PWRT_128
;
;               FGS
;               ====
;               config __FGS, CODE_PROT_OFF
;               config __FGS, CODE_PROT_ON
;
;Setting configuration fuses without using macros:
;=================================================
; To set configuration fuses without using the "config" macro, use the following
; format:
;        .section __FOSC.sec, code
;        .global __FOSC
;__FOSC: .pword CSW_FSCM_ON & FRC_PLL & FRC_LO_RANGE
;
;------------------------------------------------------------------------------

.LIST
